#pragma once

#include <common/types.h>

#include <mail_errors/error_code.h>
#include <yplatform/util/sstream.h>

#include <boost/system/error_code.hpp>

#include <vector>
#include <string>

namespace xeno::mdb {

enum database_errors : int
{
    user_removed = 0,
    tmp_error,

    COUNT
};

inline const std::string& error_message(database_errors err)
{
    static constexpr std::initializer_list<const char*> names = { "user removed from database",
                                                                  "error is temprorary" };
    static_assert(
        names.size() == database_errors::COUNT,
        "database_errors count doesn't correspond with names count");
    static const std::vector<std::string> error_names(names.begin(), names.end());

    return error_names[err];
}

}

namespace boost::system {

template <>
struct is_error_condition_enum<xeno::mdb::database_errors>
{
    static const bool value = true;
};

}

namespace xeno::mdb {

const boost::system::error_category& get_database_category();

inline boost::system::error_condition make_error_condition(database_errors e)
{
    return boost::system::error_condition(e, get_database_category());
}

}
