#pragma once

#include "errors.h"

#include <ymod_macs/module.h>
#include <pgg/service/uid_resolver.h>
#include <yplatform/find.h>

namespace xeno::mdb {

/*
 * uid_resolver receive shard_id in constructor and resolve all uids to this fixed shard
 */
class uid_resolver : public pgg::UidResolver
{
    using credentials_t = pgg::Credentials;
    using uid_resolve_params = pgg::UidResolveParams;
    using shard_t = sharpei::client::Shard;
    using shard_cb = std::function<void(mail_errors::error_code, shard_t)>;

public:
    uid_resolver(const credentials_t& credentials, const shard_id& shard_id)
        : credentials(credentials), shard_id(shard_id)
    {
        macs = yplatform::find<ymod_macs::module>("macs");
    }

    void asyncGetConnInfo(const uid_resolve_params& params, pgg::OnResolve cb) const override
    {
        using namespace pgg;
        macs->get_shard_by_id(
            shard_id, getConnInfoHandler<uid_resolve_params>(std::move(cb), params, credentials));
    }

    void asyncGetShardName(const uid_resolve_params&, pgg::OnShardName cb) const override
    {
        macs->get_shard_by_id(
            shard_id, [cb = std::move(cb)](mail_errors::error_code err, shard_t shard) {
                cb(std::move(err), std::move(shard.name));
            });
    }

private:
    boost::shared_ptr<ymod_macs::module> macs;
    credentials_t credentials;
    ::xeno::shard_id shard_id;
};

class uid_resolver_factory : public pgg::UidResolverFactory
{
    using credentials_t = pgg::Credentials;

public:
    uid_resolver_factory(const shard_id& shard_id) : shard_id(shard_id)
    {
    }

    pgg::UidResolverPtr product(
        credentials_t credentials,
        const pgg::RequestInfo&,
        pgg::UidResolver::UserType) const override
    {
        return std::make_shared<uid_resolver>(credentials, shard_id);
    }

private:
    ::xeno::shard_id shard_id;
};

}
