#include "users_polling.h"
#include <ymod_macs/module.h>
#include <yplatform/find.h>
#include <macs_pg/mailish_accounts/repository.h>

namespace xeno::mdb {

void convert_response(
    mail_errors::error_code err,
    const macs::ShardUserList& users,
    const ymod_mdb_sharder::shard_users_cb& cb)
{
    if (err)
    {
        return cb(err.base(), {});
    }
    std::vector<ymod_mdb_sharder::shard_user> res;
    res.reserve(users.size());
    for (auto& user : users)
    {
        ymod_mdb_sharder::shard_user sharder_user;
        sharder_user.uid = user.uid;
        sharder_user.is_here = user.isHere;
        sharder_user.is_deleted = user.isDeleted;
        sharder_user.here_since_ts = user.hereSinceTs;
        sharder_user.purge_ts = user.purgeTs;
        res.emplace_back(std::move(sharder_user));
    }
    cb({}, res);
};

void get_all_users(const shard_id& shard_id, const ymod_mdb_sharder::shard_users_cb& cb)
{
    auto shard = yplatform::find<ymod_macs::module>("macs")->get_shard(shard_id);
    shard->mailishAccounts().getUsers(std::bind(convert_response, ph::_1, ph::_2, cb));
}

void get_changed_users(
    const shard_id& shard_id,
    std::time_t last_moved_ts,
    std::time_t last_deleted_ts,
    const ymod_mdb_sharder::shard_users_cb& cb)
{
    auto shard = yplatform::find<ymod_macs::module>("macs")->get_shard(shard_id);
    shard->mailishAccounts().getChanges(
        last_moved_ts, last_deleted_ts, std::bind(convert_response, ph::_1, ph::_2, cb));
}

}
