#pragma once

#include <common/types.h>
#include <common/account.h>
#include <mailbox/data_types/folder.h>
#include <mailbox/data_types/message.h>
#include <xeno/operations/iteration_stat.h>

#include <yplatform/module.h>
#include <yplatform/reactor.h>
#include <yplatform/log/typed.h>

namespace xeno {

namespace mb = mailbox;

class typed_log : public yplatform::module
{
public:
    typed_log(boost::asio::io_service& io, const yplatform::ptree& conf);

    void create_folder(
        context_ptr ctx,
        uid_t uid,
        const string& full_path,
        const mb::fid_t& parent_fid,
        error err);

    void sync_message(
        context_ptr ctx,
        uid_t uid,
        const mb::path_t& path,
        const mb::fid_t_opt& fid,
        mb::imap_id_t ext_imap_id,
        mb::imap_id_t int_imap_id,
        const mb::message_opt& msg,
        const std::string& operation,
        error err);

    void iteration_result(context_ptr ctx, uid_t uid, iteration_stat_ptr stat, error err);

private:
    boost::optional<yplatform::log::tskv_logger> logger_;
};

using typed_log_ptr = boost::shared_ptr<typed_log>;

}
