#pragma once

#include <yplatform/ptree.h>

#include <memory>

namespace xeno::web::auth_check {

struct auth_check_settings
{
    auth_check_settings() = default;
    auth_check_settings(const yplatform::ptree& check_credentials)
        : imap_retries{ check_credentials.get<int>("imap_retries", 3) }
        , smtp_retries{ check_credentials.get<int>("smtp_retries", 3) }
    {
    }

    int imap_retries{ 3 };
    int smtp_retries{ 3 };
};

using auth_check_settings_ptr = std::shared_ptr<auth_check_settings>;

}
