#pragma once

#include <ymod_webserver/expirable_stream.h>

namespace xeno::web { namespace {
std::string get_user_ip(ymod_webserver::http::stream_ptr stream)
{
    auto req = stream->request();
    auto context = req->ctx();
    auto& headers = req->headers;
    auto it = headers.find("x-real-ip");
    return it != headers.end() ? it->second : context->remote_address;
}

unsigned get_user_port(ymod_webserver::http::stream_ptr stream)
{
    auto req = stream->request();
    auto context = req->ctx();
    auto& headers = req->headers;
    auto it = headers.find("x-real-port");
    if (it == headers.end()) return context->remote_port;
    try
    {
        return std::stoul(it->second);
    }
    catch (...)
    {
        return context->remote_port;
    }
}

}}
