#pragma once

#include "spawn.h"

#include <yplatform/util/tuple_unpack.h>

namespace xeno::web {
namespace detail {

/*
 * binded_spawn_t save args from constructor and on each call operator(Args&&... args)
 * spawn coroutine with ctor_args and args
 */
template <typename F, typename... CtorArgs>
struct binded_spawn_t
{
    binded_spawn_t(CtorArgs&&... ctor_args) : ctor_args(std::forward<CtorArgs>(ctor_args)...)
    {
    }

    template <typename... Args>
    void operator()(Args&&... args)
    {
        yplatform::util::call_with_tuple_args(
            &web::spawn<F, const std::decay_t<CtorArgs>&..., Args...>,
            ctor_args,
            std::forward<Args>(args)...);
    }

    const std::tuple<std::decay_t<CtorArgs>...> ctor_args;
};

}

template <typename F, typename... CtorArgs>
detail::binded_spawn_t<F, CtorArgs...> binded_spawn(CtorArgs&&... ctor_args)
{
    return detail::binded_spawn_t<F, CtorArgs...>(std::forward<CtorArgs>(ctor_args)...);
}

}
