#pragma once

#include <ymod_webserver/response.h>
#include <ymod_webserver/expirable_stream.h>
#include <ymod_webserver/server.h>

#include <yplatform/util/split.h>
#include <boost/lexical_cast.hpp>

namespace xeno::web {

#define WEB_LOG(level) WEB_LOG_STREAM(stream_, level)

#define WEB_LOG_STREAM(stream, level)                                                              \
    YLOG_CTX(stream->ctx()->logger(), stream->ctx(), level)                                        \
        << stream->request()->url.make_full_path() << " "

#define APPEND_UID_TO_LOG_PREFIX(stream, uid)                                                      \
    stream->ctx()->logger().append_log_prefix(std::to_string(uid))

std::string get_xtoken(ymod_webserver::http::stream_ptr stream);
void update_custom_log_param(
    ymod_webserver::http::stream_ptr stream,
    const std::string& key,
    const std::string& value);

}
