#include "errors.h"

namespace xeno::web {

struct error_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "xeno::web::web_errors_category";
    }

    std::string message(int v) const override
    {
        return error_message(static_cast<web_errors>(v));
    }
};

struct error_condition_category : public boost::system::error_category
{
    const char* name() const noexcept override
    {
        return "xeno::web::web_errors_condition_category";
    }

    std::string message(int v) const override
    {
        return errc_message(static_cast<web_errors_condition_category>(v));
    }

    bool equivalent(const boost::system::error_code& code, int condition) const noexcept override
    {
        using errc = web_errors_condition_category;
        errc e = static_cast<errc>(condition);
        switch (e)
        {
        case errc::ok:
            return !code;

        case errc::perm_error:
            static const std::set<error> perm_error_codes = {
                web_errors::forbidden_provider,  web_errors::incomplete_params,
                web_errors::rate_limit_exceeded, web_errors::rate_limiter_error,
                web_errors::auth_error,          web_errors::domain_not_found
            };
            return perm_error_codes.count(code);

        default:
            return boost::system::error_category::equivalent(code, condition);
        }
    }

    bool equivalent(int code, const boost::system::error_condition& condition) const
        noexcept override
    {
        return boost::system::error_category::equivalent(code, condition);
    }
};

const boost::system::error_category& error_category(web_errors)
{
    static struct error_category instance;
    return instance;
}

const boost::system::error_category& get_error_condition_category()
{
    static error_condition_category instance;
    return instance;
}

}
