#pragma once

#include <web/errors.h>
#include <web/rate_limiter.h>

#include <ymod_mdb_sharder/types.h>
#include <ymod_lease/ymod_lease.h>
#include <ymod_messenger/ymod_messenger.h>
#include <ymod_webserver/server.h>
#include <yplatform/util/per_second_accumulator.h>
#include <yplatform/module.h>

#include <boost/optional.hpp>
#include <string>
#include <memory>

namespace xeno::web {

using node_info_opt = boost::optional<ymod_mdb_sharder::node_info>;
using node_info_opt_cb = std::function<void(const node_info_opt&)>;

class impl : public yplatform::module
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using acquire_cb = rate_limiter::acquire_cb;
    using acquire_result = rate_limiter::acquire_result;

public:
    impl();
    void init(const yplatform::ptree& config);
    void start();
    void fini();

    void get_auth_master(const node_info_opt_cb& cb);
    void call_limiter(const std::string& key, const std::string& value, const acquire_cb& cb);

private:
    void on_busy(
        const std::string& resource,
        const std::string& node_id,
        ymod_lease::ballot_t ballot,
        const std::string& value);
    void on_free(const std::string& resource);
    std::set<std::string> load_cluster_settings(const yplatform::ptree& conf);
    std::string custom_key_extractor(stream_ptr stream);

    boost::asio::io_service* io_;
    ymod_mdb_sharder::node_info my_node_;
    node_info_opt master_node_;
    std::shared_ptr<ymod_lease::node> lease_node_;
    std::string auth_by_pass_resource_;
    std::shared_ptr<rate_limiter> rate_limiter_;
    yplatform::per_second_accumulator<int> total_requests_;
    int max_rps_;
};

}
