#pragma once

#include <web/common.h>
#include <web/mobile/response.h>
#include <xeno/xeno.h>

#include <ymod_mdb_sharder/users_distributor.h>
#include <yplatform/find.h>

namespace xeno::web::internal::methods {

void get_acquired_buckets_info(ymod_webserver::http::stream_ptr stream)
{
    auto shards_distributor =
        yplatform::find<ymod_mdb_sharder::shards_distributor, std::shared_ptr>(
            "shards_distributor");
    auto xeno = yplatform::find<::xeno::xeno, std::shared_ptr>("xeno");
    shards_distributor->get_acquired_buckets_info(
        [stream, xeno](const std::map<std::string, std::vector<shard_id>>& buckets) {
            auto users_count = xeno->get_users_distribution();
            json::value result = Json::arrayValue;
            for (auto& [name, shards] : buckets)
            {
                json::value bucket_info;
                bucket_info["bucket_id"] = name;
                bucket_info["shards"] = Json::arrayValue;
                for (auto& shard_id : shards)
                {
                    json::value shard_info;
                    shard_info["id"] = shard_id;
                    auto it = users_count.find(shard_id);
                    shard_info["users_count"] = it != users_count.end() ? it->second : 0;
                    bucket_info["shards"].append(shard_info);
                }
                result.append(bucket_info);
            }
            respond(stream, http_code::ok, json::to_string(result));
        });
}

}
