#pragma once

#include <web/common.h>
#include <web/mobile/response.h>

#include <ymod_mdb_sharder/shards_distributor.h>
#include <yplatform/find.h>

namespace xeno::web::internal::methods {

void add_shards_to_bucket(
    ymod_webserver::http::stream_ptr stream,
    const std::string& bucket_id,
    const std::vector<std::string>& shard_ids)
{
    yplatform::find<ymod_mdb_sharder::shards_distributor>("shards_distributor")
        ->add_shards_to_bucket(bucket_id, shard_ids);
    respond(stream, http_code::ok, "");
}

}
