#pragma once

#include <web/common.h>
#include <web/mobile/response.h>
#include <web/impl.h>

#include <ymod_mdb_sharder/types.h>
#include <yplatform/find.h>

namespace xeno::web::internal::methods {

void get_auth_master(ymod_webserver::http::stream_ptr stream)
{
    auto web = yplatform::find<web::impl>("xeno_web");
    web->get_auth_master([stream](const node_info_opt& master_node) {
        respond(stream, http_code::ok, master_node ? master_node->to_string() : "{}");
    });
}

}
