#include "cache_dump.h"

#include <web/mobile/response.h>
#include <xeno/xeno.h>

#include <yplatform/module.h>
#include <yplatform/find.h>
#include <yplatform/ptree.h>

#include <boost/property_tree/json_parser.hpp>

namespace xeno::web::internal::methods {

namespace ph = std::placeholders;

void cache_dump(ymod_webserver::http::stream_ptr stream, uid_t uid)
{
    try
    {
        auto xeno_service = yplatform::find<xeno>("xeno");
        xeno_service->cache_dump(uid, [stream = stream](error ec, yplatform::ptree dump) {
            std::string res;
            if (ec)
            {
                res = ec.message();
            }
            else
            {
                std::stringstream result;
                boost::property_tree::write_json(result, dump);
                res = result.str();
            }
            respond(stream, http_code::ok, res);
        });
    }
    catch (const std::exception& e)
    {
        respond(stream, http_code::ok, e.what());
    }
}

}
