#pragma once

#include <web/common.h>
#include <web/mobile/response.h>

#include <ymod_mdb_sharder/shards_distributor.h>
#include <yplatform/find.h>

namespace xeno::web::internal::methods {

void del_bucket(ymod_webserver::http::stream_ptr stream, const std::string& bucket_id)
{
    yplatform::find<ymod_mdb_sharder::shards_distributor>("shards_distributor")
        ->del_bucket(bucket_id);
    respond(stream, http_code::ok, "");
}

}
