#pragma once

#include <web/internal/response.h>
#include <web/common.h>

#include <xeno/xeno.h>

#include <yplatform/find.h>
#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::internal::methods {

struct invalidate_auth
{
    using yield_context = yplatform::yield_context<invalidate_auth>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    invalidate_auth(web_context_ptr web_ctx, stream_ptr stream, uid_t uid)
        : web_ctx(web_ctx), stream(stream), uid(uid)
    {
        xeno = yplatform::find<::xeno::xeno, std::shared_ptr>("xeno");
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                yield xeno->invalidate_user_auth(uid, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(ec.message());
                    yield break;
                }
                xeno->unload_user(uid);
                resp = make_ok_response();
            }
        }
        catch (const std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(e.what());
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    std::shared_ptr<::xeno::xeno> xeno;
    response resp;
};

}

#include <yplatform/unyield.h>
