#pragma once

#include <web/common.h>
#include <web/mobile/response.h>

#include <xeno/xeno.h>

#include <yplatform/find.h>
#include <boost/property_tree/json_parser.hpp>

namespace xeno::web::internal::methods {

void list_controllers(ymod_webserver::http::stream_ptr stream)
{
    // post cpu-intensive operation to separate reactor
    // to avoid webserver blocking
    auto io = yplatform::find_reactor("dump")->io();
    yplatform::find<::xeno::xeno>("xeno")->list_controllers(
        stream->ctx(), io->wrap([stream](error err, const yplatform::ptree& controllers) {
            if (err) return respond(stream, http_code::internal_server_error, err.message());
            std::stringstream str;
            boost::property_tree::write_json(str, controllers);
            respond(stream, http_code::ok, str.str());
        }));
}

}
