#pragma once

#include <web/common.h>
#include "../web_context.h"

#include <common/account.h>
#include <common/errors.h>
#include <web/impl.h>
#include <xeno/xeno.h>

#include <ymod_mdb_sharder/shards_distributor.h>
#include <yplatform/coroutine.h>

namespace xeno::web::internal::methods {

class load_user
{
    using stream_ptr = ymod_webserver::http::stream_ptr;

public:
    using yield_context = yplatform::yield_context<load_user>;

    load_user(web_context_ptr web_ctx, stream_ptr stream, uid_t uid, bool load);

    void operator()(yield_context yield_ctx, error err = {});
    void operator()(yield_context yield_ctx, error err, const ymod_mdb_sharder::node_info& owner);
    void operator()(yield_context yield_ctx, mail_errors::error_code err, const shard_id& shard_id);

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    uid_t uid_;
    bool load_;
    ymod_mdb_sharder::node_info owner_;
    ::xeno::shard_id shard_id_;
    boost::shared_ptr<ymod_macs::module> macs_;
    std::shared_ptr<ymod_mdb_sharder::shards_distributor> shards_distributor_;
    std::shared_ptr<web::impl> web_;
    std::shared_ptr<::xeno::xeno> xeno_;

    std::string response_;
    ymod_webserver::codes::code code_ = ymod_webserver::codes::ok;
};

}
