#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <common/errors.h>
#include <common/karma.h>
#include <web/impl.h>
#include <xeno/xeno.h>
#include <xiva/xiva_event.h>

#include <yplatform/coroutine.h>

namespace xeno::web::internal::methods {

class process_passport_events
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using yield_context = yplatform::yield_context<process_passport_events>;

public:
    process_passport_events(web_context_ptr web_ctx, stream_ptr stream);

    void operator()(yield_context yield_ctx, error err = {});
    void operator()(yield_context yield_ctx, mail_errors::error_code err, const shard_id& shard_id);
    xiva_event_opt unpack_event();
    bool parse_event();

private:
    response make_response(http_code code)
    {
        response res;
        res.code = code;
        return res;
    }

    web_context_ptr web_ctx_;
    stream_ptr stream_;
    xiva_event_opt event_;
    uid_t uid_;
    karma_t karma_;
    ::xeno::shard_id shard_id_;
    boost::shared_ptr<ymod_macs::module> macs_;
    std::shared_ptr<web::impl> web_;
    std::shared_ptr<::xeno::xeno> xeno_;

    response resp_;
};

}
