#pragma once

#include <web/common.h>
#include <web/mobile/response.h>

#include <xeno/xeno.h>

#include <yplatform/find.h>
#include <boost/property_tree/json_parser.hpp>

namespace xeno::web::internal::methods {

void get_providers_state(ymod_webserver::http::stream_ptr stream)
{
    // post cpu-intensive operation to separate reactor
    // to avoid webserver blocking
    auto io = yplatform::find_reactor("dump")->io();
    yplatform::find<::xeno::xeno>("xeno")->get_providers_state(
        stream->ctx(), io->wrap([stream](error err, const yplatform::ptree& stats) {
            if (err) return respond(stream, http_code::internal_server_error, err.message());
            std::stringstream str;
            boost::property_tree::write_json(str, stats);
            respond(stream, http_code::ok, str.str());
        }));
}

}
