#pragma once

#include <web/mobile/response.h>
#include <web/common.h>

#include <ymod_mdb_sharder/shards_distributor.h>
#include <yplatform/find.h>

namespace xeno::web::internal::methods {

void release_buckets_for(
    ymod_webserver::http::stream_ptr stream,
    const std::vector<std::string>& buckets,
    unsigned int duration)
{
    auto shards_distributor =
        yplatform::find<ymod_mdb_sharder::shards_distributor>("shards_distributor");
    shards_distributor->release_buckets_for(buckets, time_traits::seconds(duration));
    respond(stream, http_code::ok, "");
}

}
