#include "response.h"

namespace xeno::web::internal {

void response::respond(stream_ptr stream, error err, const std::string& description)
{
    response resp;
    resp.code = err ? http_code::internal_server_error : http_code::ok;
    resp.reason = err.message();
    resp.description = description;
    respond(stream, resp);
}

void response::respond(stream_ptr stream, const response& resp)
{
    stream->set_code(resp.code);
    json::value json_resp;
    json_resp["reason"] = resp.reason;
    json_resp["description"] = resp.description;
    stream->result_body(json::to_string(json_resp));
}

}
