#pragma once

#include <web/common.h>
#include <web/errors.h>

#include <common/errors.h>
#include <common/json.h>

namespace xeno::web::internal {

using http_code = ymod_webserver::codes::code;
using stream_ptr = ymod_webserver::http::stream_ptr;

struct response
{
    static void respond(stream_ptr stream, error err, const std::string& description = "");
    static void respond(stream_ptr stream, const response& resp);

    http_code code = http_code::ok;
    std::string reason = "ok";
    std::string description;
};

inline response make_ok_response()
{
    return {};
}

inline response make_error_response(const std::string& reason, const std::string& description = {})
{
    response ret;
    ret.code = http_code::internal_server_error;
    ret.reason = reason;
    ret.description = description;
    return ret;
}

}
