#pragma once

#include <auth/social/get_refresh_token.h>
#include <web/common.h>
#include <web/mobile/response.h>
#include <web/auth/authorize_user_op.h>

#include <yplatform/coroutine.h>

#include <memory>
#include <string>

namespace xeno::web::methods {

class auth_by_oauth
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using refresh_token_response = auth::social::refresh_token_response;
    using yield_context = yplatform::yield_context<auth_by_oauth>;

public:
    auth_by_oauth(
        web_context_ptr web_ctx,
        stream_ptr stream,
        const std::string& task_id,
        const std::string& client_id,
        const std::string& client_secret);

    auth_by_oauth(
        web_context_ptr web_ctx,
        stream_ptr stream,
        const std::string& token,
        const std::string& provider,
        const std::string& application,
        const std::string& scope,
        const std::string& client_id,
        const std::string& client_secret);

    void operator()(yield_context yield_ctx, error ec = {});
    void operator()(yield_context yield_ctx, error ec, const refresh_token_response& refresh_resp);
    void operator()(yield_context yield_ctx, error ec, const auth_result& auth_res);

private:
    ext_mailbox_ptr make_external_mailbox();
    void make_client_response();

    web_context_ptr web_ctx_;
    stream_ptr stream_;
    ext_mailbox_ptr ext_mailbox_;

    response response_;
    auth_result auth_res_;

    std::string task_id_;
    std::string token_;
    std::string provider_;
    std::string application_;
    std::string scope_;
    std::string client_id_;
    std::string client_secret_;
    account_t account_;
    std::string oauth_provider_;
    std::string oauth_app_;
    std::string refresh_token_;
    std::string access_token_;
    time_point expires_at_;
    endpoints_opt endpoints_;

    bool is_handle_by_external_token_{ false };
};

}
