#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <web/auth/authorize_user_op.h>

#include <yplatform/coroutine.h>

#include <memory>
#include <string>

namespace xeno::web::methods {

static const bool NEED_RESOLVE = true;
static const bool NOT_NEED_RESOLVE = false;

class auth_by_password
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using yield_context = yplatform::yield_context<auth_by_password>;

public:
    auth_by_password(
        web_context_ptr web_ctx,
        bool need_resolve,
        stream_ptr stream,
        const std::string& email,
        const std::string& password,
        const std::string& client_id,
        const std::string& client_secret);

    auth_by_password(
        web_context_ptr web_ctx,
        bool need_resolve,
        stream_ptr stream,
        const std::string& email,
        const std::string& imap_login,
        const std::string& imap_password,
        const std::string& imap_host,
        uint16_t imap_port,
        const std::string& imap_ssl,
        const std::string& smtp_login,
        const std::string& smtp_password,
        const std::string& smtp_host,
        uint16_t smtp_port,
        const std::string& smtp_ssl,
        const std::string& client_id,
        const std::string& client_secret);

    void operator()(yield_context yield_ctx, error ec = {});
    void operator()(yield_context yield_ctx, error ec, const endpoints& result);
    void operator()(yield_context yield_ctx, error ec, const auth_result& auth_res);
    void operator()(yield_context yield_ctx, error ec, const std::string& provider);
    void operator()(yield_context yield_ctx, error ec, bool exist_yandex_mx);

private:
    void make_client_response();
    void make_client_error_response(error ec);
    json::value make_servers_hint_json();
    json::value make_provider_json();
    ext_mailbox_ptr make_external_mailbox();
    bool is_forbidden(const std::string& provider);

    web_context_ptr web_ctx_;
    bool need_resolve_ = NEED_RESOLVE;
    stream_ptr stream_;

    response response_;
    auth_result auth_res_;

    std::string client_id_;
    std::string client_secret_;
    account_t account_;
    ext_mailbox_ptr ext_mailbox_;
    std::string provider_;
    bool exist_yandex_mx_ = false;
};

}
