#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <xeno/xeno.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

class clear_folder : boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    clear_folder(web_context_ptr web_ctx, stream_ptr stream, const fid_t& fid);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;

    struct data
    {
        uid_t uid;
        fid_t fid;

        response resp;
    };
    std::shared_ptr<data> data_{ std::make_shared<data>() };
};

}
