#include <web/common.h>

namespace xeno::web {

std::string get_xtoken(ymod_webserver::http::stream_ptr stream)
{
    auto request = stream->request();
    auto& headers = request->headers;

    auto it = headers.find("authorization");
    if (it != headers.end())
    {
        auto& [name, value] = *it;
        auto pos = value.find("OAuth");
        if (pos != std::string::npos)
        {
            return value.substr(pos + sizeof("OAuth"));
        }
    }
    return "";
}

void update_custom_log_param(
    ymod_webserver::http::stream_ptr stream,
    const std::string& key,
    const std::string& value)
{
    auto& custom_log_data = stream->request()->context->custom_log_data;
    custom_log_data[key] = value;
}

}
