#include "create_folder.h"

#include <yplatform/find.h>

#include <boost/asio/yield.hpp>

namespace xeno::web::methods {

create_folder::create_folder(
    web_context_ptr web_ctx,
    stream_ptr stream,
    const std::string& name,
    const fid_t& parent_fid)
    : web_ctx_(web_ctx), stream_(stream)
{
    data_->name = name;
    data_->parent_fid = parent_fid;
}

void create_folder::operator()(error ec, auth_response_ptr auth_resp)
{
    try
    {
        reenter(this)
        {
            data_->uid = auth_resp->uid;
            yield(yplatform::find<xeno>("xeno"))
                ->create_folder(data_->uid, data_->name, data_->parent_fid, "", *this);

            if (ec)
            {
                WEB_LOG(error) << ec.message();
                data_->resp = make_error_response(stream_, ec, "create folder error");
            }
            else
            {
                json::value resp_data;
                resp_data["fid"] = data_->result_fid;
                data_->resp = make_ok_response(stream_, resp_data);
            }
        }
    }
    catch (std::exception& e)
    {
        WEB_LOG(error) << "exception: " << e.what();
        data_->resp =
            make_error_response(stream_, e, "create_folder error: internal backend error");
    }

    if (is_complete())
    {
        respond(stream_, data_->resp);
    }
}

void create_folder::operator()(error ec, fid_t fid)
{
    data_->result_fid = fid;
    (*this)(ec);
}

}
