#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <xeno/xeno.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

class create_folder : public boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    create_folder(
        web_context_ptr web_ctx,
        stream_ptr stream,
        const std::string& name,
        const fid_t& parent_fid);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);
    void operator()(error ec, fid_t fid);

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;

    struct data
    {
        uid_t uid;
        std::string name;
        fid_t parent_fid;
        fid_t result_fid;

        response resp;
    };
    std::shared_ptr<data> data_{ std::make_shared<data>() };
};

}
