#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <xeno/xeno.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/coroutine.hpp>
#include <boost/lexical_cast.hpp>

#include <memory>
#include <string>

namespace xeno::web::methods {

class delete_items : boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    delete_items(
        web_context_ptr web_ctx,
        stream_ptr stream,
        const mid_vector& mids,
        const tid_vector& tids,
        const fid_t& current_folder);

    delete_items(web_context_ptr web_ctx, stream_ptr stream, bool purge);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;

    struct data
    {
        uid_t uid;
        mid_vector mids;
        tid_vector tids;
        bool purge;

        response resp;
    };
    std::shared_ptr<data> data_{ std::make_shared<data>() };
};

}
