#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <common/errors.h>
#include <xeno/xeno.h>

#include <boost/asio/yield.hpp>

namespace xeno::web::methods {

class messages : public boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    messages(web_context_ptr web_ctx, stream_ptr stream, bool skip_api_lock);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);
    void operator()(error ec, bool locked);

    fid_vector parse_fids();

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    bool check_api_lock_;
    fid_vector fids_;
    bool locked_ = true;

    std::shared_ptr<::xeno::xeno> xeno_;

    bool need_response_ = true;
    response response_;
};

}
#include <boost/asio/unyield.hpp>
