#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <xeno/xeno.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

class move_items : boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    move_items(
        web_context_ptr web_ctx,
        stream_ptr stream,
        const fid_t& dst_fid,
        const mid_vector& mids,
        const tid_vector& tids);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;

    struct data
    {
        uid_t uid;
        mid_vector mids;
        tid_vector tids;
        fid_t dst_fid;
        tab_opt dst_tab;

        response resp;
    };
    std::shared_ptr<data> data_{ std::make_shared<data>() };
};

}
