#include "provider.h"

#include <xeno/xeno.h>

#include <yplatform/find.h>
#include <boost/asio/yield.hpp>

namespace xeno::web::methods {

provider::provider(web_context_ptr web_ctx, stream_ptr stream) : web_ctx_(web_ctx), stream_(stream)
{
}

void provider::operator()(error ec, auth_response_ptr auth_resp)
{
    uid_ = auth_resp->uid;
    (*this)(ec);
}

void provider::operator()(error ec, const std::string& provider)
{
    try
    {
        reenter(this)
        {
            yield yplatform::find<xeno>("xeno")->get_provider(uid_, *this);
            if (ec)
            {
                WEB_LOG(error) << ec.message();
                response_ =
                    make_error_response(stream_, ec, "get provider error: internal backend error");
                yield break;
            }

            json::value resp_data;
            resp_data["provider"] = provider;
            response_ = make_ok_response(stream_, resp_data);
        }
    }
    catch (std::exception& e)
    {
        WEB_LOG(error) << "exception: " << e.what();
        response_ = make_error_response(stream_, e, "get provider error: internal backend error");
    }

    if (is_complete())
    {
        respond(stream_, response_);
    }
}

}
