#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <web/resolver.h>

#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

struct provider : boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

    provider(web_context_ptr web_ctx, stream_ptr stream);

    void operator()(error ec, auth_response_ptr auth_resp);
    void operator()(error ec, const std::string& imap_host = std::string());

    web_context_ptr web_ctx_;
    stream_ptr stream_;
    uid_t uid_{ 0 };
    response response_;
};

}
