#pragma once

#include "response.h"
#include <web/proxy.h>
#include <web/web_context.h>
#include <web/common.h>

#include <auth/authorize.h>

#include <ymod_httpclient/cluster_client.h>

namespace xeno::web::methods {

struct proxy : boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;

    proxy(web_context_ptr web_ctx, stream_ptr stream) : web_ctx_(web_ctx), stream_(stream)
    {
    }

    void operator()(error, auth::auth_response_ptr)
    {
        (*this)();
    }

    void operator()()
    {
        update_custom_log_param(stream_, "proxy_to", "mobile api");
        auto client = yplatform::find<yhttp::cluster_client, std::shared_ptr>("mobile_api_client");
        web::proxy(
            stream_,
            client,
            web_ctx_->proxy_settings(),
            [stream = stream_](error err, const yhttp::response& /*resp*/) {
                if (err)
                {
                    WEB_LOG_STREAM(stream, error) << "proxy: " << err.message();
                    auto response = make_error_response(
                        stream, web_errors::proxy_error, "proxy error: " + err.message());
                    return respond(stream, response);
                }
            });
    }

    web_context_ptr web_ctx_;
    stream_ptr stream_;
};

}
