#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>
#include <web/run_on_node.h>

#include <yplatform/yield.h>
#include <yplatform/coroutine.h>

namespace xeno::web::methods {

template <typename Method>
class proxy_to_auth_master : public std::enable_shared_from_this<proxy_to_auth_master<Method>>
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using method_ptr = std::shared_ptr<Method>;
    using yield_context = yplatform::yield_context<proxy_to_auth_master>;

public:
    template <typename... Args>
    proxy_to_auth_master(
        web_context_ptr web_ctx,
        bool need_resolve,
        stream_ptr stream,
        Args&&... args)
        : web_ctx_(web_ctx)
        , stream_(stream)
        , method_(std::make_shared<Method>(
              web_ctx_,
              need_resolve,
              stream_,
              std::forward<Args>(args)...))
    {
    }

    void operator()(yield_context)
    {
        run_on_auth_master<web::response>(
            stream_, api_type::mobile, web_ctx_, [method = method_] { yplatform::spawn(method); });
    }

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    method_ptr method_;
};

}
