#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>
#include <web/run_on_node.h>

#include <yplatform/find.h>

namespace xeno::web::mobile {

template <typename Method>
class proxy_to_owner : public std::enable_shared_from_this<proxy_to_owner<Method>>
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using method_ptr = std::shared_ptr<Method>;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    template <typename... Args>
    proxy_to_owner(web_context_ptr web_ctx, stream_ptr stream, Args&&... args)
        : web_ctx_(web_ctx)
        , stream_(stream)
        , method_(std::make_shared<Method>(web_ctx_, stream_, std::forward<Args>(args)...))
    {
    }

    void operator()(error ec, auth_response_ptr auth_resp)
    {
        if (ec)
        {
            WEB_LOG(error) << "proxy_to_owner call: " << ec.message();
            return web::response::respond(stream_, ec);
        }
        run_on_owner<web::response>(
            auth_resp->uid, stream_, api_type::mobile, web_ctx_, [method = method_, auth_resp] {
                (*method)({}, auth_resp);
            });
    }

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    method_ptr method_;
};

}
