#include "push.h"

#include <yplatform/find.h>

#include <boost/asio/yield.hpp>

namespace xeno::web::methods {

push::push(web_context_ptr web_ctx, stream_ptr stream, const std::string& uuid)
    : web_ctx_(web_ctx), stream_(stream), uuid_(uuid)
{
}

void push::operator()(error ec, auth_response_ptr auth_resp)
{
    try
    {
        reenter(this)
        {
            auth_resp_ = auth_resp;
            if (is_subscribe_request())
            {
                yield yplatform::find<xeno>("xeno")->update_user_uuid(
                    auth_resp->uid, auth_resp->xtoken_id, uuid_, *this);
                if (ec)
                {
                    WEB_LOG(error) << "cannot update uuid: " << ec.message();
                    response_ =
                        make_error_response(stream_, ec, "push error: internal backend error");
                    yield break;
                }
            }
            return methods::proxy(web_ctx_, stream_)(ec, auth_resp_);
        }
    }
    catch (std::exception& e)
    {
        WEB_LOG(error) << "exception: " << e.what();
        response_ = make_error_response(stream_, e, "push error: internal backend error");
    }

    if (is_complete())
    {
        respond(stream_, response_);
    }
}

bool push::is_subscribe_request()
{
    auto& request_url = stream_->request()->url;
    auto unsubscribe = request_url.param_value("unsubscribe", "");
    return unsubscribe.empty();
}

}
