#pragma once

#include <web/common.h>
#include "proxy.h"
#include "../web_context.h"
#include <web/mobile/response.h>

#include <xeno/xeno.h>

#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

struct push : boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

    push(web_context_ptr web_ctx, stream_ptr stream, const std::string& uuid);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);
    bool is_subscribe_request();

    web_context_ptr web_ctx_;
    stream_ptr stream_;
    std::string uuid_;
    auth_response_ptr auth_resp_;
    response response_;
};

}
