#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <xeno/xeno.h>
#include <common/json.h>
#include <mailbox/data_types/store_request.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

namespace mb = mailbox;

class send : public boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using send_request = send_request;
    using send_request_ptr = send_request_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    send(web_context_ptr web_ctx, stream_ptr stream);

    void operator()(error ec, auth_response_ptr auth_resp);
    void operator()(error ec);
    void operator()(error ec, bool duplicated_send);

    send_request_ptr make_send_request(stream_ptr stream);
    mb::mid_t parse_draft_base();
    response make_response();
    void log_operation_id(send_request_ptr request);
    void log_duplicated_send(bool duplicated_send);

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    uid_t uid_ = 0u;
    std::string user_ticket_;
    std::string imap_host_;
    send_request_ptr send_request_;
    response response_;
    bool is_already_answered_ = false;
    mb::mid_t draft_base_ = 0;
    boost::optional<std::string> provider_;
};

}
