#include "set_read_flag.h"

#include <yplatform/find.h>
#include <yplatform/util/split.h>
#include <boost/asio/yield.hpp>

namespace xeno::web::methods {

set_read_flag::set_read_flag(
    web_context_ptr web_ctx,
    stream_ptr stream,
    const mid_vector& mids,
    const tid_vector& tids,
    bool read)
    : web_ctx_(web_ctx), stream_(stream)
{
    data_->mids = mids;
    data_->tids = tids;
    data_->read = read;
}

void set_read_flag::operator()(error ec, auth_response_ptr auth_resp)
{
    try
    {
        reenter(this)
        {
            data_->uid = auth_resp->uid;
            if (data_->mids.empty() && data_->tids.empty())
            {
                WEB_LOG(error) << "missing mids and tids";
                data_->resp =
                    make_error_response(stream_, web_errors::incomplete_params, "no mids and tids");
                yield break;
            }

            yield(yplatform::find<xeno>("xeno"))
                ->set_messages_read_flag(data_->uid, data_->mids, data_->tids, data_->read, *this);

            if (ec)
            {
                WEB_LOG(error) << ec.message();
                data_->resp = make_error_response(stream_, ec, "set_read_flag error");
            }
            else
            {
                data_->resp = make_ok_response(stream_);
            }
        }
    }
    catch (std::exception& e)
    {
        WEB_LOG(error) << "exception: " << e.what();
        data_->resp =
            make_error_response(stream_, e, "set_read_flag error: internal backend error");
    }

    if (is_complete())
    {
        respond(stream_, data_->resp);
    }
}

}
