#pragma once

#include <web/common.h>
#include "../web_context.h"
#include <web/mobile/response.h>

#include <auth/authorize.h>
#include <xeno/xeno.h>
#include <common/json.h>
#include <mailbox/data_types/store_request.h>

#include <boost/asio/io_service.hpp>
#include <boost/asio/coroutine.hpp>
#include <memory>
#include <string>

namespace xeno::web::methods {

namespace mb = mailbox;

class store : public boost::asio::coroutine
{
    using stream_ptr = ymod_webserver::http::stream_ptr;
    using store_request = store_request;
    using store_request_ptr = store_request_ptr;
    using auth_response_ptr = auth::auth_response_ptr;

public:
    store(web_context_ptr web_ctx, stream_ptr stream);

    void operator()(error ec = {}, auth_response_ptr auth_resp = nullptr);
    void operator()(error ec, json::value response);

protected:
    store_request_ptr make_store_request(stream_ptr stream);
    mb::mid_t parse_draft_base();
    response make_response();

private:
    web_context_ptr web_ctx_;
    stream_ptr stream_;
    uid_t uid_{ 0u };
    store_request_ptr store_request_;
    json::value store_response_;
    response response_;
    mb::mid_t draft_base{ 0 };
};

}
