#include "update_folder.h"

#include <yplatform/find.h>
#include <yplatform/util/split.h>
#include <boost/asio/yield.hpp>

namespace xeno::web::methods {

update_folder::update_folder(
    web_context_ptr web_ctx,
    stream_ptr stream,
    const fid_t& fid,
    const std::string& name,
    const fid_t_opt& parent_fid)
    : web_ctx_(web_ctx), stream_(stream)
{
    data_->fid = fid;
    data_->name = name;
    data_->parent_fid = parent_fid;
}

void update_folder::operator()(error ec, auth_response_ptr auth_resp)
{
    try
    {
        reenter(this)
        {
            data_->uid = auth_resp->uid;
            yield(yplatform::find<xeno>("xeno"))
                ->update_folder(data_->uid, data_->fid, data_->name, data_->parent_fid, *this);

            if (ec)
            {
                WEB_LOG(error) << ec.message();
                data_->resp = make_error_response(stream_, ec, "update_folder error");
            }
            else
            {
                data_->resp = make_ok_response(stream_);
            }
        }
    }
    catch (std::exception& e)
    {
        WEB_LOG(error) << "exception: " << e.what();
        data_->resp =
            make_error_response(stream_, e, "update_folder error: internal backend error");
    }

    if (is_complete())
    {
        respond(stream_, data_->resp);
    }
}

}
