#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct create_folder
{
    using yield_context = yplatform::yield_context<create_folder>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    create_folder(
        web_context_ptr web_ctx,
        stream_ptr stream,
        uid_t uid,
        const std::string& name,
        const fid_t& parent_fid,
        const std::string& symbol)
        : web_ctx(web_ctx)
        , stream(stream)
        , uid(uid)
        , name(name)
        , parent_fid(parent_fid)
        , symbol(symbol)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                yield yplatform::find<xeno>("xeno")->create_folder(
                    uid, name, parent_fid, symbol, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, ec.message());
                    yield break;
                }
                resp = make_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    void operator()(yield_context ctx, error ec, fid_t fid)
    {
        result_fid = fid;
        (*this)(ctx, ec);
    }

    response make_response()
    {
        json::value content;
        content["fid"] = result_fid;
        return make_ok_response(std::move(content));
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    std::string name;
    fid_t parent_fid;
    std::string symbol;
    fid_t result_fid;
    response resp;
};

}

#include <yplatform/unyield.h>
