#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct delete_folder
{
    using yield_context = yplatform::yield_context<delete_folder>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    delete_folder(web_context_ptr web_ctx, stream_ptr stream, uid_t uid, const fid_t& fid)
        : web_ctx(web_ctx), stream(stream), uid(uid), fid(fid)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                yield yplatform::find<xeno>("xeno")->delete_folder(uid, fid, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, ec.message());
                    yield break;
                }
                resp = make_ok_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    fid_t fid;
    response resp;
};

}

#include <yplatform/unyield.h>
