#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct get_or_create_label
{
    using yield_context = yplatform::yield_context<get_or_create_label>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    get_or_create_label(
        web_context_ptr web_ctx,
        stream_ptr stream,
        uid_t uid,
        const std::string& name,
        const std::string& color,
        const std::string& type,
        bool force_create)
        : web_ctx(web_ctx)
        , stream(stream)
        , uid(uid)
        , name(name)
        , color(color)
        , type(type)
        , force_create(force_create)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                yield yplatform::find<xeno>("xeno")->get_or_create_label(
                    uid, name, color, type, force_create, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, ec.message());
                    yield break;
                }
                resp = make_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    void operator()(yield_context ctx, error ec, lid res)
    {
        result_lid = res;
        (*this)(ctx, ec);
    }

    response make_response()
    {
        json::value content;
        content["lid"] = result_lid;
        return make_ok_response(std::move(content));
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    std::string name;
    std::string color;
    std::string type;
    bool force_create;
    lid result_lid;
    response resp;
};

}

#include <yplatform/unyield.h>
