#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct mark
{
    using yield_context = yplatform::yield_context<mark>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    mark(
        web_context_ptr web_ctx,
        stream_ptr stream,
        uid_t uid,
        const std::string& status,
        const mid_vector& mids)
        : web_ctx(web_ctx), stream(stream), uid(uid), status(status), mids(mids)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                if (mids.empty())
                {
                    WEB_LOG_STREAM(stream, info) << "missing mids";
                    resp = make_error_response(http_code::bad_request, "missing mids");
                    yield break;
                }
                if (status == "read")
                {
                    mark_read = true;
                }
                else if (status == "not_read")
                {
                    mark_read = false;
                }
                else
                {
                    WEB_LOG_STREAM(stream, info) << "not implemented status: " << status;
                    resp = (status == "replied" || status == "forwarded") ?
                        make_ok_response() :
                        make_error_response(http_code::bad_request, "not implemented status");
                    yield break;
                }
                yield yplatform::find<xeno>("xeno")->set_messages_read_flag(
                    uid, mids, tid_vector(), mark_read, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, "mark error");
                    yield break;
                }
                resp = make_ok_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    bool mark_read;
    std::string status;
    mid_vector mids;
    response resp;
};

}

#include <yplatform/unyield.h>
