#pragma once

#include <web/common.h>
#include <web/mops/responses.h>

#include <xeno/xeno.h>

#include <yplatform/coroutine.h>
#include <yplatform/yield.h>

namespace xeno::web::mops::methods {

struct remove
{
    using yield_context = yplatform::yield_context<remove>;
    using stream_ptr = ymod_webserver::http::stream_ptr;

    remove(web_context_ptr web_ctx, stream_ptr stream, uid_t uid, const mid_vector& mids)
        : web_ctx(web_ctx), stream(stream), uid(uid), mids(mids)
    {
    }

    void operator()(yield_context ctx, error ec = {})
    {
        try
        {
            reenter(ctx)
            {
                if (mids.empty())
                {
                    WEB_LOG_STREAM(stream, info) << "missing mids";
                    resp = make_error_response(http_code::bad_request, "missing mids");
                    yield break;
                }
                yield yplatform::find<xeno>("xeno")->delete_messages(
                    uid, mids, tid_vector(), true, ctx);
                if (ec)
                {
                    WEB_LOG_STREAM(stream, error) << ec.message();
                    resp = make_error_response(http_code::internal_server_error, ec.message());
                    yield break;
                }
                resp = make_ok_response();
            }
        }
        catch (std::exception& e)
        {
            WEB_LOG_STREAM(stream, error) << e.what();
            resp = make_error_response(http_code::internal_server_error, "internal backend error");
        }

        if (ctx.is_complete())
        {
            response::respond(stream, resp);
        }
    }

    web_context_ptr web_ctx;
    stream_ptr stream;
    uid_t uid;
    mid_vector mids;
    response resp;
};

}

#include <yplatform/unyield.h>
