#include "responses.h"

namespace xeno::web::mops {

void response::respond(stream_ptr stream, const response& response)
{
    stream->result(response.code, response.body);
}

void response::respond(stream_ptr stream, http_code code, const std::string& explanation)
{
    auto response =
        code == http_code::ok ? make_ok_response() : make_error_response(code, explanation);
    respond(stream, response);
}

void response::respond(stream_ptr stream, error err, const std::string& explanation)
{
    auto response = err ? make_ok_response() :
                          make_error_response(http_code::internal_server_error, explanation);
    respond(stream, response);
}

}
