#pragma once

#include <web/common.h>
#include <common/types.h>
#include <common/json.h>

namespace xeno::web::mops {

using http_code = ymod_webserver::codes::code;
using stream_ptr = ymod_webserver::http::stream_ptr;

struct response
{
    static void respond(stream_ptr stream, const response& response);
    static void respond(stream_ptr stream, http_code code, const std::string& explanation = "");
    static void respond(stream_ptr stream, error err, const std::string& explanation = "");

    http_code code = http_code::ok;
    std::string body = "{}";
};

namespace {

response make_ok_response(json::value content = Json::objectValue)
{
    response res;
    res.body = json::to_string(content);
    return res;
}

response make_error_response(http_code code, const std::string& error = "")
{
    response res;
    json::value content;
    res.code = code;
    content["error"] = error;
    res.body = json::to_string(content);
    return res;
}

}

}
